<?PHP
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

/*************************************************************************
Original code and thanks to SK v3 Arcade Member Stats
/SK
*************************************************************************/

// Set the tab location
switch ($vbulletin->options['v3profile_tablocation'])
{
	case 1:
		$tabloc = 'profile_left_last';
	break;

	case 2:
		$tabloc = 'profile_left_first';
	break;

	default:
		$tabloc = '';
}

$blocklist = array_merge($blocklist, array(
	'v3arcade_stats' => array(
		'class' => 'v3arcade_stats',
		'title' => $vbphrase['arcade_statistics'],
		'hook_location' => $tabloc
	)
));

class vB_ProfileBlock_v3arcade_stats extends vB_ProfileBlock
{
	var $template_name = 'memberinfo_block_v3arcadestats';

	function confirm_empty_wrap()
	{
		return false;
	}

	function confirm_display()
	{
		return ($this->block_data['v3arcade_stats'] != '');
	}

	function prepare_output($id = '', $options = array())
	{
		global $show, $vbphrase, $stylevar, $db, $vbulletin;

		require_once(DIR . '/includes/v3arcade_functions.php');

		$options = convert_bits_to_array($vbulletin->options['v3profilefeatures'], $vbulletin->bf_misc_v3profile);

		$profileinfo = $this->profile->userinfo;
		$userinfo = $this->registry->userinfo;

		$show['champgames'] = false;

		// Use mini-images instead of standard size
		if ($vbulletin->options['v3profile_useimages'] == 2)
		{
			$vbulletin->options['arcadethumbsize'] = $vbulletin->options['arcademinithumbsize'];
		}

		if ($options['champgames'])
		{
			// Gets all games where user has highscore, not included inactive games
			$champgames_count = sizeof($vbulletin->v3a_awards[$profileinfo['userid']]);
			$champgames_images = '';

			if ($champgames_count)
			{
				$champgames_images = fetch_member_award_bits($profileinfo['userid']);
			}
			else
			{
				$champgames_images = $vbphrase['no_high_scores'];
			}
		}

		$show['awardimgbit'] = false;

		$show['lbrank'] = false;
		if ($options['lbrank'])
		{
			// Leaderbord rank (number of highscores), inactive games not included in count
			$leaderboardrank = ($vbulletin->v3a_champs[$profileinfo['userid']]['rank']) ? $vbulletin->v3a_champs[$profileinfo['userid']]['rank'] : $vbphrase['not_ranked'];
			$show['lbrank'] = true;
		}

		$show['mostgames'] = false;
		if ($options['mostgames'])
		{
			// Most played games. Counts all sessions, valid or not. Including inactive games
			$mostplayed_images = '';
			$mostplayed_count = 0;

			$result = $this->registry->db->query_read("
				SELECT COUNT(sessions.sessionid) AS playcount, games.gameid, games.title, games.miniimage, games.stdimage
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS sessions
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (games.gameid = sessions.gameid)
				WHERE sessions.userid = $profileinfo[userid]
					AND games.gameid IS NOT NULL
				GROUP BY sessions.gameid
				ORDER BY playcount DESC
				LIMIT " . $vbulletin->options['v3profile_mostplayed_max']
			);
			$mostplayed_count = $this->registry->db->num_rows($result);

			$show['isfirstgame'] = true;
			if ($mostplayed_count)
			{
				$show['mostgames'] = true;
				while ($game = $this->registry->db->fetch_array($result))
				{
					$game['linktitle'] = construct_phrase($vbphrase['x_y_times'], $game['title'], $game['playcount']);
					eval('$mostplayed_images .= "' . fetch_template('memberinfo_v3arcade_gamebits') . '";');
					$show['isfirstgame'] = false;
				}
			}

			$this->registry->db->free_result($result);
		}

		if ($options['sessstart'] OR $options['sessend'] OR $options['timespent'])
		{
			// Total of submitted scores (valid=true) and started sessions (valid=false). Including inactive games.
			$totalsubmitted = 0;
			$totalcount = array('0' => 0, '1' => 0, 'total' => 0);
			$result = $this->registry->db->query_read("
				SELECT COUNT(sessions.valid) AS playcount, sessions.valid, SUM(sessions.start) AS startsum, SUM(sessions.finish) AS finishsum
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS sessions
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (games.gameid=sessions.gameid)
				WHERE sessions.userid = " . $profileinfo['userid'] . "
				GROUP BY sessions.valid
			");
			if ($this->registry->db->num_rows($result))
			{
				while ($playcount = $this->registry->db->fetch_array($result))
				{
					$totalcount[$playcount['valid']] = $playcount['playcount'];
					$totaltime[$playcount['valid']] = $playcount['finishsum'] - $playcount['startsum'];
					$totalcount['total'] += $playcount['playcount'];
				}
			}
			$this->registry->db->free_result($result);

			$totalcount['total'] = vb_number_format($totalcount['total']);
			$totalcount['1'] = vb_number_format($totalcount['1']);

			$totaltime = construct_phrase(
				$vbphrase['x_hours_y_minutes_z_seconds'],
				intval($totaltime[1] / 3600),
				intval(($totaltime[1] / 60) % 60),
				intval($totaltime[1] % 60)
			);
		}

		$show['sessstart'] = $options['sessstart'];
		$show['sessend'] = $options['sessend'];
		$show['timespent'] = $options['timespent'];

		$show['lastplayed'] = $options['lastgame'];
		$show['recentgame'] = $options['recentgames'];
		if ($options['recentgames'] OR $options['lastgame'])
		{
			// Recently played games and last game played. Including inactive games
			$recentplayed_images = '';
			$recentplayed_count = 0;
			$lastplayed = array();

			$result = $this->registry->db->query_read("
				SELECT games.gameid, games.title, sessions.finish, sessions.score, games.miniimage, games.stdimage
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS sessions
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (games.gameid = sessions.gameid)
				WHERE sessions.userid = " .$profileinfo['userid'] . "
					AND sessions.valid = 1
				ORDER BY sessions.finish DESC
				LIMIT " . $vbulletin->options['v3profile_recentplayed_max']
			);
			$recentplayed_count = $this->registry->db->num_rows($result);
			if ($recentplayed_count)
			{
				$show['isfirstgame'] = true;

				while ($game = $this->registry->db->fetch_array($result))
				{
					if (empty($lastplayed))
					{
						$lastplayed = array(
							'gameid' => $game['gameid'],
							'title' => $game['title'],
							'score' => v3_score_format($game['score']),
							'date' => vbdate($vbulletin->options['dateformat'], $game['finish']),
							'time' => vbdate($vbulletin->options['timeformat'], $game['finish'])
						);
					}

					$game['linktitle'] = construct_phrase(
						$vbphrase['w_x_points_y_z'],
						$game['title'],
						v3_score_format($game['score']),
						vbdate($vbulletin->options['dateformat'], $game['finish']),
						vbdate($vbulletin->options['timeformat'], $game['finish'])
					);

					eval('$recentplayed_images .= "' . fetch_template('memberinfo_v3arcade_gamebits') . '";');
					$show['isfirstgame'] = false;
				}
			}
			else
			{
				$show['lastplayed'] = false;
				$show['recentgame'] = false;
			}

			$this->registry->db->free_result($result);
		}

		$show['challenges'] = false;
		if ($options['challenges'])
		{
			// Challenges
			$challenges = array('total' => 0, 'wins' => 0, 'lost' => 0, 'initiated' => 0);
			$result = $this->registry->db->query_read("
				SELECT fromuserid, touserid, winnerid, loserid
				FROM " . TABLE_PREFIX . "v3arcade_challenges AS challenges
				WHERE (fromuserid = $profileinfo[userid] OR touserid = $profileinfo[userid])
					AND status = 3
			");
			if ($this->registry->db->num_rows($result))
			{
				$show['challenges'] = true;
				while ($challenge = $this->registry->db->fetch_array($result))
				{
					$challenges['total']++;
					if ($challenge['fromuserid'] == $profileinfo['userid'])
					{
						$challenges['initiated']++;
					}
					if ($challenge['winnerid'] == $profileinfo['userid'])
					{
						$challenges['wins']++;
					}
					else if ($challenge['loserid'] == $profileinfo['userid'])
					{
						$challenges['lost']++;
					}
				}
			}

			if (($profileinfo['arcadeoptions'] & 1) AND $profileinfo['userid'] != $userinfo['userid'])
			{
				$show['challenges'] = true;
				$show['challengelink'] = true;
			}
		}

		$show['tournaments'] = false;
		if ($options['tournaments'] AND $vbulletin->options['tourmnt_enabled'])
		{
			$tournaments = array(
				'starts' => 0,
				'losts' => 0,
				'champs' => 0,
				'disq' => 0,
				'withdraws' => 0
			);
			$result = $this->registry->db->query_read("
				SELECT COUNT(players.status) AS statuscount, players.status
				FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS players
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments AS tournaments ON (players.tid = tournaments.tid)
				WHERE players.userid = $profileinfo[userid]
					AND tournaments.status = 2
				GROUP BY players.status
			");
			if ($this->registry->db->num_rows($result))
			{
				$show['tournaments'] = true;
				while ($tournmt = $this->registry->db->fetch_array($result))
				{
					switch($tournmt['status'])
					{
						case 10:
							$tournaments['losts'] += $tournmt['statuscount'];
						break;
						case 11:
							$tournaments['disq'] += $tournmt['statuscount'];
						break;
						case 30:
							$tournaments['champs'] += $tournmt['statuscount'];
						break;
						case 40:
							$tournaments['withdraws'] += $tournmt['statuscount'];
						break;
					}
				}

				$tournaments['starts'] = $tournaments['champs'] + $tournaments['losts'] + $tournaments['disq'];
			}

			// Invite member to tournaments
			$show['tournamentinvite'] = false;
			if ($this->registry->userinfo['userid'] AND $this->registry->userinfo['userid'] != $profileinfo['userid'])
			{
				$gettours = $this->registry->db->query_read("
					SELECT tournament.tid, tournament.title, game.title AS gametitle
					FROM " . TABLE_PREFIX . "v3arcade_tournaments AS tournament
					LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS game ON (tournament.gameid = game.gameid)
					WHERE tournament.creator = " . $this->registry->userinfo['userid'] . "
						AND status = 0
					ORDER BY tournament.title
				");
				while ($tours = $this->registry->db->fetch_array($gettours))
				{
					$show['tournamentinvite'] = true;
					eval('$v3toursel .= "' . fetch_template('memberinfo_v3arcade_tournament_options') . '";');
				}
			}
		}

		eval('$v3arcadestats = "' . fetch_template('memberinfo_v3arcade_stats') . '";');

		$this->block_data['v3arcade_stats'] = $v3arcadestats;
	}
}
?>
